<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentOutbound;

/**
 * Selling Partner APIs for Fulfillment Outbound.
 *
 * The Selling Partner API for Fulfillment Outbound lets you create applications that help a seller fulfill Multi-Channel Fulfillment orders using their inventory in Amazon's fulfillment network. You can get information on both potential and existing fulfillment orders.
 *
 * The version of the OpenAPI document: 2020-07-01
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
class CurrentStatus
{
    /**
     * Possible values of this enum.
     */
    final public const IN_TRANSIT = 'IN_TRANSIT';

    final public const DELIVERED = 'DELIVERED';

    final public const RETURNING = 'RETURNING';

    final public const RETURNED = 'RETURNED';

    final public const UNDELIVERABLE = 'UNDELIVERABLE';

    final public const DELAYED = 'DELAYED';

    final public const AVAILABLE_FOR_PICKUP = 'AVAILABLE_FOR_PICKUP';

    final public const CUSTOMER_ACTION = 'CUSTOMER_ACTION';

    final public const UNKNOWN = 'UNKNOWN';

    final public const OUT_FOR_DELIVERY = 'OUT_FOR_DELIVERY';

    final public const DELIVERY_ATTEMPTED = 'DELIVERY_ATTEMPTED';

    final public const PICKUP_SUCCESSFUL = 'PICKUP_SUCCESSFUL';

    final public const PICKUP_CANCELLED = 'PICKUP_CANCELLED';

    final public const PICKUP_ATTEMPTED = 'PICKUP_ATTEMPTED';

    final public const PICKUP_SCHEDULED = 'PICKUP_SCHEDULED';

    final public const RETURN_REQUEST_ACCEPTED = 'RETURN_REQUEST_ACCEPTED';

    final public const REFUND_ISSUED = 'REFUND_ISSUED';

    final public const RETURN_RECEIVED_IN_FC = 'RETURN_RECEIVED_IN_FC';

    public function __construct(private readonly string $value)
    {
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public static function getAllowableEnumValues() : array
    {
        return [
            self::IN_TRANSIT,
            self::DELIVERED,
            self::RETURNING,
            self::RETURNED,
            self::UNDELIVERABLE,
            self::DELAYED,
            self::AVAILABLE_FOR_PICKUP,
            self::CUSTOMER_ACTION,
            self::UNKNOWN,
            self::OUT_FOR_DELIVERY,
            self::DELIVERY_ATTEMPTED,
            self::PICKUP_SUCCESSFUL,
            self::PICKUP_CANCELLED,
            self::PICKUP_ATTEMPTED,
            self::PICKUP_SCHEDULED,
            self::RETURN_REQUEST_ACCEPTED,
            self::REFUND_ISSUED,
            self::RETURN_RECEIVED_IN_FC,
        ];
    }

    public function toString() : string
    {
        return $this->value;
    }
}
