<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Services;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Services.
 *
 * With the Services API, you can build applications that help service providers get and modify their service orders and manage their resources.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ServiceUploadDocument implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    final public const CONTENT_TYPE_TIFF = 'TIFF';

    final public const CONTENT_TYPE_JPG = 'JPG';

    final public const CONTENT_TYPE_PNG = 'PNG';

    final public const CONTENT_TYPE_JPEG = 'JPEG';

    final public const CONTENT_TYPE_GIF = 'GIF';

    final public const CONTENT_TYPE_PDF = 'PDF';

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static string $openAPIModelName = 'ServiceUploadDocument';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'content_type' => 'string',
        'content_length' => 'float',
        'content_md5' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'content_type' => null,
        'content_length' => 'int64',
        'content_md5' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'content_type' => 'contentType',
        'content_length' => 'contentLength',
        'content_md5' => 'contentMD5',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'content_type' => 'setContentType',
        'content_length' => 'setContentLength',
        'content_md5' => 'setContentMd5',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'content_type' => 'getContentType',
        'content_length' => 'getContentLength',
        'content_md5' => 'getContentMd5',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['content_type'] = $data['content_type'] ?? null;
        $this->container['content_length'] = $data['content_length'] ?? null;
        $this->container['content_md5'] = $data['content_md5'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return string[]
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return null[]|string[]
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return string[]
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return string[]
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return string[]
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getContentTypeAllowableValues() : array
    {
        return [
            self::CONTENT_TYPE_TIFF,
            self::CONTENT_TYPE_JPG,
            self::CONTENT_TYPE_PNG,
            self::CONTENT_TYPE_JPEG,
            self::CONTENT_TYPE_GIF,
            self::CONTENT_TYPE_PDF,
        ];
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['content_type'] === null) {
            throw new AssertionException("'content_type' can't be null");
        }

        $allowedValues = $this->getContentTypeAllowableValues();

        if (null !== $this->container['content_type'] && !\in_array($this->container['content_type'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'content_type', must be one of '%s'",
                    $this->container['content_type'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        if ($this->container['content_length'] === null) {
            throw new AssertionException("'content_length' can't be null");
        }

        if (($this->container['content_length'] > 5.24288E+6)) {
            throw new AssertionException("invalid value for 'content_length', must be smaller than or equal to 5.24288E+6.");
        }

        if (($this->container['content_length'] < 1)) {
            throw new AssertionException("invalid value for 'content_length', must be bigger than or equal to 1.");
        }

        if (null !== $this->container['content_md5'] && !\preg_match("/^[A-Za-z0-9\\\\+\/]{22}={2}$/", (string) $this->container['content_md5'])) {
            throw new AssertionException("invalid value for 'content_md5', must be conform to the pattern /^[A-Za-z0-9\\\\+\/]{22}={2}$/.");
        }
    }

    /**
     * Gets content_type.
     */
    public function getContentType() : string
    {
        return $this->container['content_type'];
    }

    /**
     * Sets content_type.
     *
     * @param string $content_type The content type of the to-be-uploaded file
     */
    public function setContentType(string $content_type) : self
    {
        $this->container['content_type'] = $content_type;

        return $this;
    }

    /**
     * Gets content_length.
     */
    public function getContentLength() : float
    {
        return $this->container['content_length'];
    }

    /**
     * Sets content_length.
     *
     * @param float $content_length The content length of the to-be-uploaded file
     */
    public function setContentLength(float $content_length) : self
    {
        $this->container['content_length'] = $content_length;

        return $this;
    }

    /**
     * Gets content_md5.
     */
    public function getContentMd5() : ?string
    {
        return $this->container['content_md5'];
    }

    /**
     * Sets content_md5.
     *
     * @param null|string $content_md5 An MD5 hash of the content to be submitted to the upload destination. This value is used to determine if the data has been corrupted or tampered with during transit.
     */
    public function setContentMd5(?string $content_md5) : self
    {
        $this->container['content_md5'] = $content_md5;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
