<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\MerchantFulfillment;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Merchant Fulfillment.
 *
 * The Selling Partner API for Merchant Fulfillment helps you build applications that let sellers purchase shipping for non-Prime and Prime orders using Amazon’s Buy Shipping Services.
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class CreateShipmentRequest implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static string $openAPIModelName = 'CreateShipmentRequest';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'shipment_request_details' => '\AmazonPHP\SellingPartner\Model\MerchantFulfillment\ShipmentRequestDetails',
        'shipping_service_id' => 'string',
        'shipping_service_offer_id' => 'string',
        'hazmat_type' => '\AmazonPHP\SellingPartner\Model\MerchantFulfillment\HazmatType',
        'label_format_option' => '\AmazonPHP\SellingPartner\Model\MerchantFulfillment\LabelFormatOptionRequest',
        'shipment_level_seller_inputs_list' => '\AmazonPHP\SellingPartner\Model\MerchantFulfillment\AdditionalSellerInputs[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'shipment_request_details' => null,
        'shipping_service_id' => null,
        'shipping_service_offer_id' => null,
        'hazmat_type' => null,
        'label_format_option' => null,
        'shipment_level_seller_inputs_list' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'shipment_request_details' => 'ShipmentRequestDetails',
        'shipping_service_id' => 'ShippingServiceId',
        'shipping_service_offer_id' => 'ShippingServiceOfferId',
        'hazmat_type' => 'HazmatType',
        'label_format_option' => 'LabelFormatOption',
        'shipment_level_seller_inputs_list' => 'ShipmentLevelSellerInputsList',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'shipment_request_details' => 'setShipmentRequestDetails',
        'shipping_service_id' => 'setShippingServiceId',
        'shipping_service_offer_id' => 'setShippingServiceOfferId',
        'hazmat_type' => 'setHazmatType',
        'label_format_option' => 'setLabelFormatOption',
        'shipment_level_seller_inputs_list' => 'setShipmentLevelSellerInputsList',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'shipment_request_details' => 'getShipmentRequestDetails',
        'shipping_service_id' => 'getShippingServiceId',
        'shipping_service_offer_id' => 'getShippingServiceOfferId',
        'hazmat_type' => 'getHazmatType',
        'label_format_option' => 'getLabelFormatOption',
        'shipment_level_seller_inputs_list' => 'getShipmentLevelSellerInputsList',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['shipment_request_details'] = $data['shipment_request_details'] ?? null;
        $this->container['shipping_service_id'] = $data['shipping_service_id'] ?? null;
        $this->container['shipping_service_offer_id'] = $data['shipping_service_offer_id'] ?? null;
        $this->container['hazmat_type'] = $data['hazmat_type'] ?? null;
        $this->container['label_format_option'] = $data['label_format_option'] ?? null;
        $this->container['shipment_level_seller_inputs_list'] = $data['shipment_level_seller_inputs_list'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return string[]
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return null[]|string[]
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return string[]
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return string[]
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return string[]
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['shipment_request_details'] === null) {
            throw new AssertionException("'shipment_request_details' can't be null");
        }

        $this->container['shipment_request_details']->validate();

        if ($this->container['shipping_service_id'] === null) {
            throw new AssertionException("'shipping_service_id' can't be null");
        }

        if ($this->container['label_format_option'] !== null) {
            $this->container['label_format_option']->validate();
        }
    }

    /**
     * Gets shipment_request_details.
     */
    public function getShipmentRequestDetails() : ShipmentRequestDetails
    {
        return $this->container['shipment_request_details'];
    }

    /**
     * Sets shipment_request_details.
     *
     * @param \AmazonPHP\SellingPartner\Model\MerchantFulfillment\ShipmentRequestDetails $shipment_request_details shipment_request_details
     */
    public function setShipmentRequestDetails(ShipmentRequestDetails $shipment_request_details) : self
    {
        $this->container['shipment_request_details'] = $shipment_request_details;

        return $this;
    }

    /**
     * Gets shipping_service_id.
     */
    public function getShippingServiceId() : string
    {
        return $this->container['shipping_service_id'];
    }

    /**
     * Sets shipping_service_id.
     *
     * @param string $shipping_service_id an Amazon-defined shipping service identifier
     */
    public function setShippingServiceId(string $shipping_service_id) : self
    {
        $this->container['shipping_service_id'] = $shipping_service_id;

        return $this;
    }

    /**
     * Gets shipping_service_offer_id.
     */
    public function getShippingServiceOfferId() : ?string
    {
        return $this->container['shipping_service_offer_id'];
    }

    /**
     * Sets shipping_service_offer_id.
     *
     * @param null|string $shipping_service_offer_id identifies a shipping service order made by a carrier
     */
    public function setShippingServiceOfferId(?string $shipping_service_offer_id) : self
    {
        $this->container['shipping_service_offer_id'] = $shipping_service_offer_id;

        return $this;
    }

    /**
     * Gets hazmat_type.
     */
    public function getHazmatType() : ?HazmatType
    {
        return $this->container['hazmat_type'];
    }

    /**
     * Sets hazmat_type.
     *
     * @param null|\AmazonPHP\SellingPartner\Model\MerchantFulfillment\HazmatType $hazmat_type hazmat_type
     */
    public function setHazmatType(?HazmatType $hazmat_type) : self
    {
        $this->container['hazmat_type'] = $hazmat_type;

        return $this;
    }

    /**
     * Gets label_format_option.
     */
    public function getLabelFormatOption() : ?LabelFormatOptionRequest
    {
        return $this->container['label_format_option'];
    }

    /**
     * Sets label_format_option.
     *
     * @param null|\AmazonPHP\SellingPartner\Model\MerchantFulfillment\LabelFormatOptionRequest $label_format_option label_format_option
     */
    public function setLabelFormatOption(?LabelFormatOptionRequest $label_format_option) : self
    {
        $this->container['label_format_option'] = $label_format_option;

        return $this;
    }

    /**
     * Gets shipment_level_seller_inputs_list.
     *
     * @return null|\AmazonPHP\SellingPartner\Model\MerchantFulfillment\AdditionalSellerInputs[]
     */
    public function getShipmentLevelSellerInputsList() : ?array
    {
        return $this->container['shipment_level_seller_inputs_list'];
    }

    /**
     * Sets shipment_level_seller_inputs_list.
     *
     * @param null|\AmazonPHP\SellingPartner\Model\MerchantFulfillment\AdditionalSellerInputs[] $shipment_level_seller_inputs_list a list of additional seller input pairs required to purchase shipping
     */
    public function setShipmentLevelSellerInputsList(?array $shipment_level_seller_inputs_list) : self
    {
        $this->container['shipment_level_seller_inputs_list'] = $shipment_level_seller_inputs_list;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
